# 【NO.185】ringbuffer 消息队列 内存池 性能优化利器

## 1.简约而不简单的ringbuffer

最近在研究srsLTE的代码,其中就发现一个有意思的数据结构------ringbuffer。

虽然，这是一个很基本的数据结构，但时，它在LTE这种通信协议栈系统中却大行其道，也是很容易被协议开发人员忽略的。在整个通信协议的开发团队中，一般会有一个平台中间件的团队，他们的任务是给业务部门提供高性能、高可靠性的中间件代码，如内存池、线程池、消息通信机制、日志系统等等。这篇文章就来讨论下这个简约而不简单的ringbuffer。

## 2.ringbuffer数据结构

环形缓冲器（ringr buffer），也称作圆形队列（circular queue），循环缓冲区（cyclic buffer），圆形缓冲区（circula buffer），是一种用于表示一个固定尺寸、头尾相连的缓冲区的数据结构，适合缓存数据流。

在通信程序中，经常使用环形缓冲器作为数据结构来存放通信中发送和接收的数据。环形缓冲区是一个先进先出的循环缓冲区，可以向通信程序提供对缓冲区的互斥访问。

![img](https://pic4.zhimg.com/80/v2-e62501b9e35913bf4af8340ffde589a3_720w.webp)

## 3.用法

圆形缓冲区的一个有用特性是：当一个数据元素被用掉后，其余数据元素不需要移动其存储位置。相反，一个非圆形缓冲区（例如一个普通的队列）在用掉一个数据元素后，其余数据元素需要向前搬移。换句话说，圆形缓冲区适合实现先进先出缓冲区，而非圆形缓冲区适合后进先出缓冲区。

圆形缓冲区适合于事先明确了缓冲区的最大容量的情形。扩展一个圆形缓冲区的容量，需要搬移其中的数据。因此一个缓冲区如果需要经常调整其容量，用链表实现更为合适。

写操作覆盖圆形缓冲区中未被处理的数据在某些情况下是允许的。特别是在多媒体处理时。例如，音频的生产者可以覆盖掉声卡尚未来得及处理的音频数据。

## 4.工作机制

一般的，圆形缓冲区需要4个指针 ：

- 在内存中实际开始位置；
- 在内存中实际结束位置，也可以用缓冲区长度代替；
- 存储在缓冲区中的有效数据的开始位置（读指针）；
- 存储在缓冲区中的有效数据的结尾位置（写指针）。
  读指针、写指针可以用整型值来表示。下例为一个未满的缓冲区的读写指针：

![img](https://pic1.zhimg.com/80/v2-386e64896fd987c1c8fae13f7d766f20_720w.webp)

下例为一个满的缓冲区的读写指针:

![img](https://pic2.zhimg.com/80/v2-54ff4d3d06cbe882d4ecb0d053d1b219_720w.webp)

## 5.区分缓冲区满或者空

缓冲区是满、或是空，都有可能出现读指针与写指针指向同一位置，有多种策略用于检测缓冲区是满、或是空。常用的做法是总是保持一个存储单元为空，缓冲区中总是有一个存储单元保持未使用状态。缓冲区最多存入 size-1个数据。如果读写指针指向同一位置，则缓冲区为空。如果写指针位于读指针的相邻后一个位置，则缓冲区为满。这种策略的优点是简单、鲁棒；缺点是语义上实际可存数据量与缓冲区容量不一致，测试缓冲区是否满需要做取余数计算。

出色的KFIFO

kfifo是一种"First In First Out “数据结构，它采用了前面提到的环形缓冲区来实现，提供一个无边界的字节流服务。采用环形缓冲区的好处为，当一个数据元素被用掉后，其余数据元素不需要移动其存储位置，从而减少拷贝提高效率。更重要的是，kfifo采用了并行无锁技术，kfifo实现的单生产/单消费模式的共享队列是不需要加锁同步的。

熟悉Linux内核的读者应该对kfifo.c和kfifo.h并不陌生.kfifo经过简单改进就可以在用户态进行使用，笔者在实际项目中多次使用，经过实践，代码是稳定、可靠、高效的。

## 6.ringbuffer蕴藏的巨大能量

### 6.1 **消息队列**

ringbuffer的一个天生的高性能的消息队列，特别是在单生产/单消费的模式下，它是无锁的，这点非常重要。之前的文章曾介绍过，LTE的协议栈实现对时序是敏感的，这意味着代码的执行不能有阻塞的风险，而线程间的通信几乎是协议栈中必须的基本功能。因此，用ringbuffer去实现一个高性能的消息队列是一种非常理想的方案。当然，由于不同的线程的运行模型不同，例如PDCP线程属于包驱动的线程，大部分时间它是属于阻塞的，当有数据到达，如RRC可以通过消息队列给PDCP发送一个消息，这个时候需要唤醒PDCP进行处理，这个是属于线程同步的技术范畴，可以通过MUTEX、信号量等方案去实现。如果你的系统的Linux（rt-patch）,eventfd也是不错的选择，eventfd优势是可以使用poll、select、epoll等操作，这样协议栈的线程实现的方式上较为简洁，关键是eventfd性能也非常的快。

当然这里需要划一个重点，不同线程间需要独立的消息队列，来保证FIFO的无锁特性，当然缺点是会浪费一些内容，但是这在协议栈的开发中往往不是什么大的问题，性能和稳定永远是第一位的。由于FIFO通常是固定大小的数据结构不太适合可变消息的发送，这里的技巧是队列里面只放消息的指针，消息的内容通常是在内存池中申请不同大小的结构。

srsLTE代码的实现PDCP和RLC并不一定是以单独的线程运行的，但是在实际项目中，为了性能的考虑，通常是需要线程化的，且上下行也要线程化，且绑定不同的CPU核，来保证性能。

下图是PDCP和RLC线程的消息队列实例：

![img](https://pic1.zhimg.com/80/v2-6588c70906a33414dd03cfdd9dc33f20_720w.webp)

### 6.2 内存池

内存池在通信协议栈和很多的软件中都是常用的技术，它的好处是除了可以避免内存碎片，更重要的一点是，内存是预先申请的，并且自我管理，在申请和释放的效率更快，这对协议栈的实现是十分重要的。

内存池的实现在方式都是大同小异的，通常将内存分为8字节、16字节、32字节… 1K等大小不同的内存块，并通过链表的方式进行管理。具体的实现方式可以自行到github上搜索，实现方式都是类似的。

那么，ringbuffer和内存池有什么关系呢？实际上，ringbuffer和内存池的实现并无直接的关系，但是内存池在实现上有个至关重要的问题，那就内存的申请和释放可能不是在同一个线程中。简单的说就是，内存的申请和释放可能存在竞争的情况，通常的做法是进行加锁进行保护。但是加锁的操作可能对协议的时序产生不确定的影响，这对时序要求较高的协议实现（如CMAC）是无法接受的。

ringbuffer的优秀的特性又一次被应用的淋漓尽致，做法也是相当的简单，就是使用ringbuffer单生产/单消费的模式的无锁特性，释放的线程可以将需要释放的地址使用ringbuffer发送给申请的线程，由申请的线程进行内存的释放，这就就不需要加锁的操作，因为同一个线程不会出现并发的链表操作。

下图是结合了消息队列和内存池技术的一次应用，该方案是十分经典和有效的，在很多大型的通信系统中都能看到这种方案的影子：

![img](https://pic2.zhimg.com/80/v2-72f19fb8b1433a9d9ae3c527f549784d_720w.webp)

## 7.总结

本文是结合笔者的实际项目经验，介绍了ringbuffer在协议栈软件开发中的一些应用和技巧，主要是ringbuffer单生产/单消费的模式的无锁特性在内存池内存释放和消息队列中的应用技巧。如果读者也有类似的性能方面的系统需求，可以不妨试试 ringbuffer，性能超乎你的想象，且没有特别复杂的算法和CPU指令集的限制。

原文地址：https://zhuanlan.zhihu.com/p/556524313

作者：linux